' Constantes

' Affectation des entrees
const IN_OBJET                       = 1    ' Detection objet
const IN_CELL_ETIQUETTE              = 2    ' Detection etiquette (echenillage)

' Axes
const AXE_CONVOYEUR                  = 1    ' moteur convoyeur
const AXE_ETIQUETTE                  = 2    ' moteur etiqueteuse

' Parametres EE
const EE_V_ETIQUETTE                = 0   ' vitesse étiquette (hz)
const EE_ACC_ETIQUETTE              = 1   ' acceleration etiquette (khz/s)
const EE_DEC_ETIQUETTE              = 2   ' deceleration etiquette (khz/s)

const EE_RES_ETIQUETTE              = 3   ' resolution etiquette (pulses/mm) 1 decimale
'const EE_CPT_TOTAL_ETIQUETTES       = 4   ' compteur total etiquettes (DWORD)
const EE_TEMPO_AV_OBJET             = 5   ' duree de deplacement du convoyeur pour amener l'objet de la cellule d'entree, au poste étiquetage (ms)

const EE_CHECK_NEW_CNC              = 9   ' Flag indiquant si les paramètres ont déjà été écrits en EEprom


' Parametres recettes
const RCP_TAILLE_RECETTES           = 5632 ' taille des recettes
const RCP_IDX_RECETTE               = 5633 ' index sur la recette 0
const RCP_NOM_RECETTE               = 5637 ' debut de la recette 0 (4 WORD pour stocker le nom en ASCII, 8 caractères )
const RCP_LG_MAX_ETIQUETTE          = 5642 ' longueur maxi de l'etiquette (en mm)
const RCP_POS_ETIQUETTE             = 5643 ' position pour pose d'etiquette (en mm)


' Ram utilisateur
const RAM_CPT_ETIQUETTES            = 0 ' compteur d'etiquettes partiel


' Bits Modbus
const MBB_GCYCLE                    = 320 ' controle cycle global'
const MBB_ONOFF_CONVOYEUR           = 321 ' marche / arret tapis convoyeur
const MBB_TEST_ETIQUETTE            = 322 ' lance une etiquette
const MBB_RAZ_CPT                   = 323 ' Remise à zéro du compteur d'étiquettes (partiel)
const MBB_ALARM_ETIQ                = 324 ' Alarme defaut defilement etiquette



' Toute premiere Initialisation des parametres par défaut, dans la carte
if GetEEData16(EE_CHECK_NEW_CNC) <> &hAAAA then

   SetEEData16 EE_V_ETIQUETTE    , 9000
   SetEEData16 EE_ACC_ETIQUETTE  , 1200
   SetEEData16 EE_DEC_ETIQUETTE  , 1400
   SetEEData16 EE_RES_ETIQUETTE  , 102 'NB: 1 decimale'
   SetEEData16 EE_TEMPO_AV_OBJET, 4000

   SetUserMem RAM_CPT_ETIQUETTES, 0
   'SetEEData32 EE_CPT_TOTAL_ETIQUETTES, 0
   
   SetMBReg RCP_TAILLE_RECETTES , 15
   SetMBReg RCP_IDX_RECETTE, 0
   SetMBReg RCP_NOM_RECETTE,    &h4C46
   SetMBReg RCP_NOM_RECETTE+1,  &h4341
   SetMBReg RCP_NOM_RECETTE+2,  &h4E4F
   SetMBReg RCP_NOM_RECETTE+3,  &h2031
   SetMBReg RCP_LG_MAX_ETIQUETTE, 40 'mm'
   SetMBReg RCP_POS_ETIQUETTE, 290 'mm, => distance entre la cellule etiquette et le point de contact avec l'objet'

   SetEEData16 EE_CHECK_NEW_CNC, &hAAAA
endif

CalculParametres()


' Initialisation à la mise sous tension ou en cas d'arrêt d'urgence
Initialisation:
? "Initialisation"

Unlock
OUTALL 0
StopAxes &h1f

for i= 320 to 327 : SetMBBit i, 0 : next i 'remise à zéro des bits utilisateurs'
Pause 200
for i= 1 to 2 : SetPos i, 0 : next i 'mise à zero des repères de position des axes 1 et 2'

CptPartiel = 0
GCYCLE     = 10
GTESTETIQUETTE = 10


DO                             
   
  if stsbit(8) = 1 then goto Initialisation ' deverrouillage de la carte'   
  if IsMBPrmChanged then CalculParametres() ' Actualisation des variables apres toute modification de registres Modbus' 

  'Remise à zero du compteur (Bouton sur IHM)'
  if GetMBBit(MBB_RAZ_CPT) then ResetCompteur

  ' Bit de Marche/Arret du convoyeur (ici independant du cycle principal)'
  if DFMBit(1, GetMBBit(MBB_ONOFF_CONVOYEUR)) then
      MoveAxe AXE_CONVOYEUR, 1200, 9000, 1400, 999999999
  endif
  if DFDBit(1, GetMBBit(MBB_ONOFF_CONVOYEUR)) then
      StopAxes AXE_CONVOYEUR
  endif

  ' Bit d'acquitement de l'alarme de defilement d'etiquette' 
  if DFDBit(2, GetMBBit(MBB_ALARM_ETIQ)) then
    ClearAlarme()
  endif

   
  select case(GCYCLE)
   case 10
      if GetMBBit(MBB_GCYCLE) and not GetMBBit(MBB_TEST_ETIQUETTE) then
         ? "Depart cycle"
         GCYCLE = 20
      endif
      
   case 20
      if DFM(IN_OBJET) then
      ? "Detection Objet"
        SetTimer AvanceObjet, GetEEData16(EE_TEMPO_AV_OBJET)
        ? " -> Timer ON <- "
        GCYCLE = 30
      endif
      
   case 30
      if not GetTimer(AvanceObjet) then
      ? " -> Timer OFF <- "
        GCYCLE = 40
      endif
      
   case 40
      SetPos AXE_ETIQUETTE, 0
      MoveAxe AXE_ETIQUETTE, AccEtiquette, VitEtiquette, DecEtiquette, LongueurEtiquettePulses*2
      GCYCLE = 50
      
   case 50
      if DFM(IN_CELL_ETIQUETTE) then
         ? "Cellule etiquette en ", GetPos(AXE_ETIQUETTE)
         MoveAxe AXE_ETIQUETTE, AccEtiquette, VitEtiquette, DecEtiquette, GetPos(AXE_ETIQUETTE) + PositionEtiquettePulses
         ? "MoveAxe start pose etiquette", AXE_ETIQUETTE, ", ", AccEtiquette, ", ", VitEtiquette, ", ", DecEtiquette, ", ", GetPos(AXE_ETIQUETTE) + PositionEtiquettePulses
         GCYCLE = 60
      elseif  stsbit(22+AXE_ETIQUETTE-1)=0 then 'si l'AXE_ETIQUETTE a fini le mouvement de 2 longueurs :
         SetMBBit MBB_GCYCLE, 0 'arret du cycle'
         SetAlarme ()
         GCYCLE = 10
      endif      
      
   case 60
      if not stsbit(22+AXE_ETIQUETTE-1) then 'si l'AXE_ETIQUETTE a fini son mouvement pour 1 etiquette :
        CptPartiel = CptPartiel+1
        SetUserMem RAM_CPT_ETIQUETTES, CptPartiel
        ? " !!! ",CptPartiel," etiquettes posees !!!"
        GCYCLE = 10
      endif
      
   case else      
      ? "Erreur du cycle principal, etape ", GCYCLE

  end select


  select case(GTESTETIQUETTE)
    case 10
    if GetMBBit(MBB_TEST_ETIQUETTE) and not(GetMBBit(MBB_GCYCLE)) then
      ? "Test Etiquette"
      GTESTETIQUETTE = 20
    endif

    case 20
    SetPos AXE_ETIQUETTE, 0
    MoveAxe AXE_ETIQUETTE, AccEtiquette, VitEtiquette,  DecEtiquette, LongueurEtiquettePulses*2
    GTESTETIQUETTE = 30

    case 30
    if DFM(IN_CELL_ETIQUETTE) then
      ? "Cellule etiquette en ", GetPos(AXE_ETIQUETTE)
      MoveAxe AXE_ETIQUETTE, AccEtiquette, VitEtiquette, DecEtiquette, GetPos(AXE_ETIQUETTE) + PositionEtiquettePulses
      ? "MoveAxe start pose etiquette", AXE_ETIQUETTE, ", ", AccEtiquette, ", ", VitEtiquette, ", ", DecEtiquette, ", ", GetPos(AXE_ETIQUETTE) + PositionEtiquettePulses
      SetMBBit MBB_TEST_ETIQUETTE, 0 'arret du cycle'
      GTESTETIQUETTE = 10
    elseif  stsbit(22+AXE_ETIQUETTE-1)=0 then 'si l'AXE_ETIQUETTE a fini le mouvement de 2 longueurs :
      SetAlarme ()
      SetMBBit MBB_TEST_ETIQUETTE, 0 'arret du cycle'
      GTESTETIQUETTE = 10
    endif

    case else      
      ? "Erreur du cycle Test Etiquette, etape ", GTESTETIQUETTE

  end select

LOOP


sub CalculParametres
   ? "CalculParametres"
   
   VitEtiquette    = GetEEData16(EE_V_ETIQUETTE)
   AccEtiquette    = GetEEData16(EE_ACC_ETIQUETTE)
   DecEtiquette    = GetEEData16(EE_DEC_ETIQUETTE)
   ResEtiquette    = GetEEData16(EE_RES_ETIQUETTE) /10
   DeplaceObjet    = GetEEData16(EE_TEMPO_AV_OBJET)
   'CptTotal        = GetEEData32(EE_CPT_TOTAL_ETIQUETTES)
   CptPartiel      = GetUserMem(RAM_CPT_ETIQUETTES)
   LongueurEtiquettePulses  = GetMBReg(RCP_LG_MAX_ETIQUETTE)*ResEtiquette
   PositionEtiquettePulses  = GetMBReg(RCP_POS_ETIQUETTE)*ResEtiquette   
end sub

sub ResetCompteur
  'SetEEData32 EE_CPT_TOTAL_ETIQUETTES, GetEEData32(EE_CPT_TOTAL_ETIQUETTES) + CptPartiel
  SetUserMem RAM_CPT_ETIQUETTES, 0
  SetMBBit MBB_RAZ_CPT, 0
  CptPartiel = 0
end sub

sub SetAlarme()
  SetMBBit MBB_ALARM_ETIQ, 1
  SetMBBit MBB_ONOFF_CONVOYEUR, 0 
  ? "   -- > ALARME : defaut defilement etiquette"
  SetMBBit MBB_GCYCLE, 0
end sub

sub ClearAlarme()
  SetMBBit MBB_ALARM_ETIQ, 0
  'SetMBBit MBB_ONOFF_CONVOYEUR, 1
  ? "   -- > ALARME : acquittee"
  SetMBBit MBB_GCYCLE, 1
end sub


OnError:
Outall 0
StopAxes &h1F